/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.gunsrpg.common.block;

import dev.toma.gunsrpg.common.block.BaseHorizontalBlock;
import dev.toma.gunsrpg.common.capability.PlayerData;
import dev.toma.gunsrpg.common.container.AmmoBenchContainer;
import dev.toma.gunsrpg.common.init.Skills;
import dev.toma.gunsrpg.common.tileentity.AmmoBenchTileEntity;
import dev.toma.gunsrpg.util.SkillUtil;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.inventory.container.SimpleNamedContainerProvider;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.fml.network.NetworkHooks;

public class AmmoBenchBlock
extends BaseHorizontalBlock {
    private static final ITextComponent TITLE = new TranslationTextComponent("screen.gunsrpg.ammo_bench");

    public AmmoBenchBlock(String name) {
        super(name, AbstractBlock.Properties.func_200945_a((Material)Material.field_151573_f).func_200948_a(2.2f, 18.0f).harvestTool(ToolType.PICKAXE).harvestLevel(1).func_235861_h_().func_226896_b_());
    }

    public ActionResultType func_225533_a_(BlockState blockState, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult traceResult) {
        TileEntity tileEntity;
        if (!world.field_72995_K && (tileEntity = world.func_175625_s(pos)) instanceof AmmoBenchTileEntity) {
            AmmoBenchTileEntity ammoBenchTile = (AmmoBenchTileEntity)tileEntity;
            if (!PlayerData.hasActiveSkill(player, Skills.GUN_PARTS_SMITH)) {
                player.func_146105_b(SkillUtil.getMissingSkillText(Skills.GUN_PARTS_SMITH), true);
                return ActionResultType.FAIL;
            }
            NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)new SimpleNamedContainerProvider((windowId, playerInventory, interactingPlayer) -> new AmmoBenchContainer(windowId, playerInventory, ammoBenchTile), TITLE), (BlockPos)pos);
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.CONSUME;
    }

    public void func_196243_a(BlockState state, World world, BlockPos pos, BlockState oldState, boolean flag) {
        TileEntity tile;
        if (!state.func_203425_a(oldState.func_177230_c()) && (tile = world.func_175625_s(pos)) instanceof AmmoBenchTileEntity) {
            AmmoBenchTileEntity tileEntity = (AmmoBenchTileEntity)tile;
            InventoryHelper.func_180175_a((World)world, (BlockPos)pos, (IInventory)tileEntity);
            world.func_175666_e(pos, (Block)this);
        }
        super.func_196243_a(state, world, pos, oldState, flag);
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new AmmoBenchTileEntity();
    }
}

